<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 02. Aug. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * Validator test class file.
 *  
 * PHP Version 5
 *  
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: ValidatorStaticTest.php 262 2007-08-03 14:48:41Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: ValidatorStaticTest.php 262 2007-08-03 14:48:41Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 02. Aug. 2007
 */

/**
 * Call MetaTest::main() if this source file is executed directly. 
 */
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "ValidatorTest::main");
}

/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once 'OpenDocumentPHP/util/Validator.php';

/**
 * Test class for util/Validator.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.3 - 02. Aug. 2007
 */
class ValidatorStaticTest extends PHPUnit_Framework_TestCase 
{
	/**
	 * Runs the test methods of this class.
	 *
	 * @access public
	 * @static
	 * @since       0.5.3 - 02. Aug. 2007
	 */
	public static function main() 
	{
		require_once "PHPUnit/TextUI/TestRunner.php";
		$suite = new PHPUnit_Framework_TestSuite("ValidatorTest");
		$result = PHPUnit_TextUI_TestRunner :: run($suite);
	}
	
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access protected
	 * @since       0.5.3 - 02. Aug. 2007
	 */
	protected function setUp() 
	{
	}
	
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access protected
	 * @since       0.5.3 - 02. Aug. 2007
	 */
	protected function tearDown() 
	{
	}

    /**
     * 
     * @since       0.5.3 - 02. Aug. 2007
     */
    public function testIsPositiveInteger() 
    {
        $this->assertTrue(Validator::isPositiveInteger(1));
        
        $this->assertFalse(Validator::isPositiveInteger(-1));
        $this->assertFalse(Validator::isPositiveInteger(0));
    }

    /**
     * @since       0.5.3 - 02. Aug. 2007
     */
    public function testIsInteger() 
    {
        $this->assertTrue(Validator::isInteger(1));
        $this->assertTrue(Validator::isInteger(-1234));
        
        $this->assertFalse(Validator::isInteger(1.0));
        $this->assertFalse(Validator::isInteger(-1.0));
        $this->assertFalse(Validator::isInteger(.01));
        $this->assertFalse(Validator::isInteger('1'));
        $this->assertFalse(Validator::isInteger('1.0'));
    }

    /**
     * @since       0.5.3 - 02. Aug. 2007
     */
    public function testCheckNCName() {
        $this->assertFalse(Validator::checkNCName('12345'));
        $this->assertFalse(Validator::checkNCName('1abcb'));
        $this->assertFalse(Validator::checkNCName('ab:cd'));
        $this->assertFalse(Validator::checkNCName('ab;cd'));
        
        $this->assertTrue(Validator::checkNCName('a12345'));
        $this->assertTrue(Validator::checkNCName('A1.2-3_45'));
        $this->assertTrue(Validator::checkNCName('A12345'));
    }

    /**
     * @since       0.5.3 - 02. Aug. 2007
     */
    public function testCheckStyleNameRef() {
        $this->assertFalse(Validator::checkStyleNameRef('12345'));
        $this->assertFalse(Validator::checkStyleNameRef('1abcb'));
        $this->assertFalse(Validator::checkStyleNameRef('ab:cd'));
        $this->assertFalse(Validator::checkStyleNameRef('ab;cd'));
        
        $this->assertTrue(Validator::checkStyleNameRef('a12345'));
        $this->assertTrue(Validator::checkStyleNameRef('A1.2-3_45'));
        $this->assertTrue(Validator::checkStyleNameRef('A12345'));
        $this->assertTrue(Validator::checkStyleNameRef(null));
    }

    /**
     * @since       0.5.3 - 02. Aug. 2007
     */
    public function testIsColor() 
    {
        $this->assertTrue(Validator::isColor('#123456'));
        $this->assertTrue(Validator::isColor('#FFFFFF'));
        $this->assertTrue(Validator::isColor('#aabbcc'));
        $this->assertTrue(Validator::isColor('#F0f0F0'));
        
        $this->assertFalse(Validator::isColor('#FGFGFG'));
        $this->assertFalse(Validator::isColor('#F0f0F0f0'));
        $this->assertFalse(Validator::isColor('#FOfOFO'));
        $this->assertFalse(Validator::isColor('f0F0f0'));                            
    }

    /**
     * @todo Implement testIsPositiveLength().
     */
    public function testIsPositiveLength() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
    }

    /**
     * @todo Implement testCheckFamilyValues().
     */
    public function testCheckFamilyValues() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
          'This test has not been implemented yet.'
        );
    }
}
	

if (PHPUnit_MAIN_METHOD == "ValidatorTest::main") {
	ValidatorTest::main();
}
?>
