<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 02. Feb. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * ManifestTest class file for unit tests with PHPUnit. 
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: ManifestTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: ManifestTest.php 264 2007-08-06 08:29:08Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/*
 *  Call OpenDocumentArchiveTest::main() if this source file is executed directly.
 */
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "ManifestTest::main");
}
/**
 * 
 */
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once "PHPUnit/TextUI/TestRunner.php";

/**
 * 
 */
require_once 'OpenDocumentPHP/manifest/ManifestDocument.php';

/**
 * Test class for manifest/ManifestDocument.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  test
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */
class ManifestTest extends PHPUnit_Framework_TestCase {

	const RelaxNG10Path = 'etc/Schemata/ODF1.0/';
	const RelaxNG11Path = 'etc/Schemata/ODF1.1/';	
	const RelaxNG10Schema = 'OpenDocument-manifest-schema-v1.0-os.rng';
	const RelaxNG11Schema = 'OpenDocument-manifest-schema-v1.1-cs1.rng';
	
	/**
	 * Manifest document.
	 * @var 		ManifestDocument Manifest to test.
	 * @access 		private
	 */
	private $doc;
	
	private $basepath;
	/**
	 * Runs the test methods of this class.
	 *
	 * @access 		public
	 * @static
     * @since       0.5.0 - 08. Feb. 2007
	 */
    public static function main() 
    {
        $result = PHPUnit_TextUI_TestRunner :: run(self::suite());
    }
    
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     * @since       0.5.3 - 02. Aug. 2007
     */
    public static function suite() 
    {
        $suite = new PHPUnit_Framework_TestSuite("manifest tests");
        $suite->addTestSuite('ManifestTest');
        return $suite;
    }
    
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access     protected
	 * @since      0.5.0 - 08. Feb. 2007
	 */
	protected function setUp() {
		$this->doc = new ManifestDocument();
        if (PHPUnit_MAIN_METHOD == 'PHPUnit_TextUI_Command::main') {
		            $this->basepath = "../";
        } else {
            $this->basepath = "./";
        }
	}
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access     protected
	 * @since      0.5.0 - 08. Feb. 2007
	 */
	protected function tearDown() {
		unset ($this->doc);
	}
	/**
	 * Test an emtpy Manifest against RelaxNG Schema of OpenDocument Format 1.1 cs
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function testEmptyManifestAgainstRelaxNG10Schema() {
		$manifest = new ManifestDocument();
		$test = $manifest->relaxNGValidate($this->basepath . self :: RelaxNG10Path . self :: RelaxNG10Schema);
		$this->assertTrue($test, 'Manifest document does not match Manifest Relax NG schema 1.0.');
	}
	/**
	 * Test an emtpy Manifest against RelaxNG Schema of OpenDocument Format 1.1 cs
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	public function testEmptyManifestAgainstRelaxNG11Schema() {
		$manifest = new ManifestDocument();
		$test = $manifest->relaxNGValidate($this->basepath . self :: RelaxNG11Path . self :: RelaxNG11Schema);
		$this->assertTrue($test, 'Manifest document does not match Manifest Relax NG schema 1.1.');
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13. Feb. 2007
	 */
	function testLoadHTML() {
		$this->assertFalse($this->doc->loadHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13. Feb. 2007
	 */
	function testLoadHTMLFile() {
		$this->assertFalse($this->doc->loadHTMLFile(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13. Feb. 2007
	 */
	function testSaveHTML() {
		$this->assertFalse($this->doc->saveHTML(' '));
	}
	/**
	 * The method of the class is not needed, so it should always return 'false'!
	 * 
	 * @access 		public
	 * @since 		0.5.1 - 13. Feb. 2007
	 */
	function testSaveHTMLFile() {
		$this->assertFalse($this->doc->saveHTMLFile(' '));
	}
}

if (PHPUnit_MAIN_METHOD == "ManifestTest::main") {
	ManifestTest::main();
}
?>