<?php
/*
 * Created on 06.06.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 *
 *
 * $Id: DOMCompareTest.php 180 2007-06-08 11:04:38Z nmarkgraf $
 */
// Call MetaTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
	define("PHPUnit_MAIN_METHOD", "DOMCompareTest::main");
}
require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";
require_once 'tools/DOMCompare.php';
/**
 * Test class for DOMCompare.
 * 
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 180 $
 * @package    	OpenDocumentPHP
 * @subpackage	test
 * @since 		0.5.2 - 30.05.2007
 */
class DOMCompareTest extends PHPUnit_Framework_TestCase {

	private $compare;

	/**
	 * Runs the test methods of this class.
	 *
	 * @access 		public
	 * @static
	 * @since 		0.5.2 - 06.06.2007
	 */
	public static function main() {
		require_once "PHPUnit/TextUI/TestRunner.php";
		$suite = new PHPUnit_Framework_TestSuite("DOMCompareTest");
		$result = PHPUnit_TextUI_TestRunner :: run($suite);
	}
	/**
	 * Sets up the fixture, for example, open a network connection.
	 * This method is called before a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.2 - 06.06.2007
	 */
	protected function setUp() {
		// We set up the $compare with a fresh made DOMCompare
		$this->compare = new DOMCompare();
	}
	/**
	 * Tears down the fixture, for example, close a network connection.
	 * This method is called after a test is executed.
	 *
	 * @access 		protected
	 * @since 		0.5.2 - 06.06.2007
	 */
	protected function tearDown() {
	}

	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 * 
	 * <code>
	 * <root></root>
	 * </code>
	 * 
	 * should be DOM-equal to
	 * 
	 * <code>
	 * <root/>
	 * </code>
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testOne() {
		$doc1 = DOMDocument :: loadXML('<root></root>');
		$doc2 = DOMDocument :: loadXML('<root/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertTrue($result);
	}

	/**
	 * The same test as testOne but now with a static call to the compare method.
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testOneStatic() {
		$doc1 = DOMDocument :: loadXML('<root></root>');
		$doc2 = DOMDocument :: loadXML('<root/>');
		$result = DOMCompare :: compare($doc1, $doc2);
		$this->assertTrue($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo></foo>
	 * </code>
	 *
	 * should NOT be DOM-equal to
	 *
	 * <code>
	 * <bar/>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testTwo() {
		$doc1 = DOMDocument :: loadXML('<foo></foo>');
		$doc2 = DOMDocument :: loadXML('<bar/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertFalse($result);
	}
	/**
	 * The same test as testOne but now with a static call to the compare method.
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testTwoStatic() {
		$doc1 = DOMDocument :: loadXML('<foo></foo>');
		$doc2 = DOMDocument :: loadXML('<bar/>');
		$result = DOMCompare :: compare($doc1, $doc2);
		$this->assertFalse($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo attr="bar"></foo>
	 * </code>
	 *
	 * should be DOM-equal to
	 *
	 * <code>
	 * <foo attr="bar/>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testThree() {
		$doc1 = DOMDocument :: loadXML('<foo attr="bar"></foo>');
		$doc2 = DOMDocument :: loadXML('<foo attr="bar"/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertTrue($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <root><foo attr="bar"></foo></root>
	 * </code>
	 *
	 * should be DOM-equal to
	 *
	 * <code>
	 * <root><foo attr="bar/></root>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testFour() {
		$doc1 = DOMDocument :: loadXML('<root><foo attr="bar"></foo></root>');
		$doc2 = DOMDocument :: loadXML('<root><foo attr="bar"/></root>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertTrue($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo attr1="bar" attr2="foobar"/>
	 * </code>
	 *
	 * should be DOM-equal to
	 *
	 * <code>
	 * <foo attr2="foobar" attr1="bar/>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 06.06.2007
	 */
	function testFive() {
		$doc1 = DOMDocument :: loadXML('<foo attr1="bar" attr2="foobar" />');
		$doc2 = DOMDocument :: loadXML('<foo attr2="foobar" attr1="bar"/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertTrue($result);
	}

	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo attr="bar"/>
	 * </code>
	 *
	 * should NOT be DOM-equal to
	 *
	 * <code>
	 * <foo attr="foobar" attr1="bar""/>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 07.06.2007
	 */
	function testSix() {
		$doc1 = DOMDocument :: loadXML('<foo attr1="bar"/>');
		$doc2 = DOMDocument :: loadXML('<foo attr1="foobar"/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertFalse($result);
	}

	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo> bar </foo>
	 * </code>
	 *
	 * should NOT be DOM-equal to
	 *
	 * <code>
	 * <foo />
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 07.06.2007
	 */
	function testSeven() {
		$doc1 = DOMDocument :: loadXML('<foo> bar </foo>');
		$doc2 = DOMDocument :: loadXML('<foo />');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertFalse($result);
	}

	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo xmlns="urn:myns:bar"/>
	 * </code>
	 *
	 * should be DOM-equal to
	 *
	 * <code>
	 * <foo xmlns="urn:notmyns:bar"/>
	 * </code>
	 *
	 * You must use "urn:notmyns:bar" and "urn:myns:bar", because you need a valid URI or URN. In This case
	 * we use two different URNs.
	 * 
	 * @link http://www.rfc-editor.org/rfc/rfc2141.txt URN
	 * @link http://www.rfc-editor.org/rfc/rfc3986.txt URI
	 * @link http://www.w3.org/TR/REC-xml-names/ XML namespaces
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 07.06.2007
	 */
	function testEight() {
		$doc1 = DOMDocument :: loadXML('<foo xmlns="urn:myns:bar"/>');
		$doc2 = DOMDocument :: loadXML('<foo xmlns="urn:notmyns:bar"/>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertFalse($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * 	<root>
	 * 		<child />
	 * 	</root>
	 * </code>
	 *
	 * should be DOM-equal to
	 *
	 * <code>
	 * 	<root><child/></root>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 07.06.2007
	 */
	function testNine() {
		$xml = '<root>' . "\n" . '  <child/>' . "\n" . '</root>';
		$doc1 = DOMDocument :: loadXML($xml);
		$doc2 = DOMDocument :: loadXML('<root><child/></root>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertTrue($result);
	}
	/**
	 * A very basic test with just one node written in two DOM-equal notations.
	 *
	 * <code>
	 * <foo> bar </foo>
	 * </code>
	 *
	 * should NOT be DOM-equal to
	 *
	 * <code>
	 * <foo> bir </foo>
	 * </code>
	 *
	 * @access 		public
	 * @since 		0.5.2 - 08.06.2007
	 */
	function testTen() {
		$doc1 = DOMDocument :: loadXML('<foo> bar </foo>');
		$doc2 = DOMDocument :: loadXML('<foo> bir </foo>');
		$result = $this->compare->compare($doc1, $doc2);
		$this->assertFalse($result);
	}
	
}

if (PHPUnit_MAIN_METHOD == "DOMCompareTest::main") {
	DOMCompareTest :: main();
}
?>
