<?php
/*
 * Created on 18.06.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 *
 *
 * $Id: odmanager.php 203 2007-07-13 09:51:23Z nmarkgraf $
 */
require_once('OpenDocumentPHP/OpenDocumentArchive.php');
/**
 * This is a little demo application. A OpenDocument manager. It will store some OpenDocument files in a directory
 * and show their meta datas.
 *
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team
 * @license 	http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version    	$Revision: 203 $
 * @package    	OpenDocumentPHP/tools
 * @subpackage	demoapp
 * @since 		0.5.3 - 18.06.2007
 * 
 */
class odmanager {
	/**
	 * 
	 */
	const uploadDir = '/uploads';
	/**
	 * The allowed file suffixes. This list is case in sensetive!	 
	 */
	const allowedSuffixes = '(odt|ods)';
	/**
	 * 
	 */
	const maxFilesize = 3000000;
	/**
	 * 
	 */
	private $storeDir;
	/**
	 * 
	 */
	private $baseURL;
	/**
	 * 
	 */
	function __construct($storedir=null) {
		if (is_null($stroredir)) {
			$this->storeDir= dirname( __FILE__ ) . self::uploadDir;			
		} else {
			$this->storeDir = $storedir . self::uploadDir ;
		}
		$this->baseURL = dirname( $_SERVER['PHP_SELF'] );
		/* *** FIX ME ***
		 * 
		 * Check if uploaddir exists and is writeable. If not, die with an error!
		 */
	}
	/**
	 * Checks if the suffix 
	 * @param $filename
	 * @return 
	 */
	function checkSuffix($filename) {
		// Use a regular expression. The "/i" means 'ignore case'!
		return preg_match("/\." .self::allowedSuffixes . "$/i", $filename);
	}
	
	/**
	 * 
	 */
	static function checkFilesize($size) {
		return ($size <= $getMaxFilesize());
	}
	/**
	 * 
	 */
	static function getMimeTypeOfFile($fullpath) {
		// Open as OpenDocumentArchive
		$docArchive = new OpenDocumentArchive();
		$docArchive->open($fullpath);
		// Retrive mime type
		$mimeType = $docArchive->getMimeType();
		$docArchive->close( false );
		return $mimeType;	
	}
	/**
	 * 
	 */
	public function getMaxFilesize() {
		return self::maxFilesize;
	}
	/**
	 * 
	 */
	public function getBaseURL() {
		return $this->baseURL;
	}
	/**
	 *
	 */
	public function getBaseURLUpload() {
		return $this->baseURL . self::upadloadDir;
	}
	/**
	 * 
	 */
	public function getStoreDir() {
		return $this->storeDir;
	}
	/**
	 * 
	 */
	function checkUploaded() {
	}

}
?>