<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
		<link rel="stylesheet" href="stylesheets/main.css" type="text/css" />
<?php
/*
 * Created on 18.06.2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 *
 *
 * $Id: dispatcher.php 203 2007-07-13 09:51:23Z nmarkgraf $
 */
//
require_once('odmanager.php');
require_once('OpenDocumentPHP/OpenDocumentArchive.php');
require_once('OpenDocumentPHP/OpenDocumentText.php');
require_once('OpenDocumentPHP/OpenDocumentSpreadsheet.php');
//
$manager = new odmanager();
//
unset($msg);

if (isset($_GET['cmd'])) {
	$msg = 'Scanning upload';
	switch ($_GET['cmd']) {
		case 'upload' : 
			if ($_POST['submit'] = "Send File") {
				$msg = 'Found out that the submit button was pressed.';
				if(is_uploaded_file($_FILES['file']['tmp_name'])) {
					$msg = 'Found out that some file was uploaded.';
					if ($manager->checkSuffix($_FILES['file']['name'])) {
						$msg = 'Found out that the uploaded file had the right suffix.';
						//
						$target_path = $manager->getStoreDir().'/'.basename( $_FILES['file']['name']);
						//
						if(move_uploaded_file($_FILES['file']['tmp_name'], $target_path)) {
							$msg = 'File successfully uploaded!';
						} else {
							$msg = 'File not successfully added!!!';
						}						
					}
				}
			}
			break;
		default :
			$msg = '???';
	}
}

?>
		<title>OpenDocument Manager <?php if (isset($msg)) echo '- '.$msg?></title>
	
	</head>
	<body>
		<h1>OpenDocument Manager</h1>
		<p>The is a demo application for OpenDocumentPHP. No real document manager.</p>
		<h2>Upload new document</h2>
			<form method="post" action="dispatcher.php?cmd=upload" enctype="multipart/form-data">
			<input type="hidden" name="MAX_FILE_SIZE" value="<?php echo $manager->getMaxFilesize();?>" /> 
			<label for="filename">New File:<label><input id="filename" name="file" maxlength="<?php echo $manager->getMaxFilesize(); ?>" type="file" /> 
			<input type="submit" value="Send File" /> <?php
				if (isset($msg)) {
					echo "						<br/>\n						<p>".$msg."</p>\n";
				}?></form>
				
<h2>Document View</h2>
<?php
	echo "<!--\n";
	echo "<p>".$manager->getStoreDir().":</p>\n";
	echo "-->\n";
?>
			<table class="filelist">
			<tr class="fileheader">
				<th>Filename</th>
				<th>Mimetype</th>
				<th>Initial Creator</th>
				<th>Creation Date</th>
			</tr>
<?php
	if ($dirHandle = opendir($manager->getStoreDir())) {
		while ($file = readdir($dirHandle)) {
			if ($file !="." && $file !="..") { ?>
				<tr class="file">
					<td><a href="<?php echo $manager->getBaseURLUpload().'/'.$file;?>"><?php echo $file; ?></a></td>
<?php
			if ($manager->checkSuffix($file)) {
				// We might be able to handle this file ;-)
				// First get mimetype of the document.
				$fullpath = $manager->getStoreDir().'/'.$file;
				$mimeType = $manager->getMimeTypeOfFile($fullpath);
				?>
					<td><?php	echo '['.$mimeType.']'; ?></td>
				<?php
				
				unset($doc);
				
				switch ($mimeType) {
					case 'application/vnd.oasis.opendocument.text':
						$doc = new OpenDocumentText($fullpath);
						break;
					case 'application/vnd.oasis.opendocument.calc' :
						$doc = new OpenDocumentSpreadsheet($fullpath);
						break;
					default :
						$doc = null;					
				}
				if (isset($doc)) {
					$meta = $doc->getMeta();
					?><td><?php echo $meta->getMetaFragment()->getInitialCreator(); ?></td>
					<td><?php echo $meta->getMetaFragment()->getCreationDate(); ?></td>
					<?php
					$doc->close( false );
				}
			} else {
			?>
			<td />
			<td />
			<td />
			<?php
			}				
?></tr>				
<?php				
			}
		}
		closedir($dirHandle);
	} 
?>	
			</table>
	</body>
</html>
