<?php
/*
 * Created on 22. Feb. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: SimpleMetaOutput.php 203 2007-07-13 09:51:23Z nmarkgraf $
 */
require_once 'OpenDocumentPHP/OpenDocumentAbstract.php';

/**
 * Sample: A simple OpenDocument Text.
 * 
 * @author 		Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright 	Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license		http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version		$Revision: 203 $
 * @package		OpenDocumentPHP
 * @subpackage 	samples
 * @since 		0.5.2 - 22. Feb. 2007
 */
 
 class MyOpenDocument extends OpenDocumentAbstract {
 	function __construct() {
 		parent::__construct();
 	}
 }
 
 $filename = './SimpleOpenDocument.odt';
 
 if ($argc == 2) {
 	$filename = $argv[1];
 }
 
 $package = new MyOpenDocument();
  
 if ($package->open($filename) === TRUE) {
 
 $metaDoc = $package->getMeta();
 
 $meta = $metaDoc->getMetaFragment();
 
 $dc = $metaDoc->getDublinCoreFragment();
 
 //
 echo "Dublin core meta data:\n";
 echo "======================\n";
 echo "Creator \t: " . $dc->getCreator(). "\n";
 echo "Description \t: ". $dc->getDescription() . "\n";
 echo "Language \t: ". $dc->getLanguage() . "\n";
 echo "Subject \t: ". $dc->getSubject() . "\n";
 echo "Title \t\t: ". $dc->getTitle() . "\n";
 // 
 echo "\n";
 //
 echo "Open Office meta data:\n";
 echo "======================\n";
 echo "Initial creator\t: ". $meta->getInitialCreator() . "\n";
 echo "Generator \t: ". $meta->getGenerator() . "\n";
 echo "Creation date \t: ". $meta->getCreationDate() . "\n";
 echo "Print date \t:". $meta->getPrintDate() . "\n";
 
 $package->close();
 } else {
 	echo "ERROR: File ".$filename." not found!\n";
 }
  
?>
