<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 19. Jan. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * Paragraph class file.
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: Paragraph.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_text
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: Paragraph.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.0 - 08. Feb. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * Paragraph class.
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_text
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since 		0.5.0 - 08. Feb. 2007
 */
class Paragraph extends ODPElement 
{
    /**
     * Constructor method.
     * 
     * @since       0.5.2 - 26. Feb. 2007
     */
    function __construct($elem=null, $value=null, $namespace=null) 
    {         
        if (is_null($elem)) {
           parent::__construct('text:p', '', self::TEXT);
        } else {
            if ($elem instanceof DOMElement) {
                parent::__construct($elem);
            } else {
                parent::__construct($elem, $value, $namespace);         
            }            
        }   
    }

	/* -- */
	/* ID */
	/* -- */
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setId($id) 
	{
		$this->setAttributeNS(self :: TEXT, 'text:id', $id);
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function getId() 
	{
		return $this->getAttributeNS(self :: TEXT, 'id');
	}
	
	/* ---------- */
	/* Style Name */
	/* ---------- */
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setStyleName($name) 
	{
		$this->setAttributeNS(self :: TEXT, 'text:style-name', $name);
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function getStyleName() 
	{
		return $this->getAttributeNS(self :: TEXT, 'style-name');
	}
	
	/* ---------- */
	/* Class Name */
	/* ---------- */
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setClassNames($names) 
	{
		$this->setAttributeNS(self :: TEXT, 'text:class-names', $names);
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function getClassNames() 
	{
		return $this->getAttributeNS(self :: TEXT, 'class-names');
	}
	
	/* --------------- */
	/* Cond Style Name */
	/* --------------- */
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function setCondStyleName($name) 
	{
		$this->setAttributeNS(self :: TEXT, 'text:cond-style-name', $name);
	}
	
	/**
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 */
	function getCondStyleName() 
	{
		return $this->getAttributeNS(self :: TEXT, 'cond-style-name');
	}
	
	/* ------ */
	/* append */
	/* ------ */
	/**
	 * Append a text node or a DOMElement as a child to the current paragraph node.
	 * 
	 * @access 		public
	 * @since 		0.5.0 - 08. Feb. 2007
	 * @param 		mixed $content Eigther a text (as a string) or a child node 
	 * 							   (as a DOMElement) which will be appended to the
	 *                             current paragraph node. 
	 */
	function append($content) 
	{
		if (is_string($content)) {
			$this->append($this->ownerDocument->createTextNode($content));
		} else {
			$this->appendChild($content);
		}
	}
}
?>
